import type { RouteLocationInterface, RouteParamsInterface, RouteRequestInterface } from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

import type { ResponseRouteChecklistGet } from "./checklist.get.js";

const locationRestChecklistPut: RouteLocationInterface = {
    path: "/checklist/:id",
    method: RouteHttpVerb.PUT,
};

interface RequestRouteChecklistPut extends RouteRequestInterface {
    state: boolean;
}

interface ParamsRouteChecklistPut extends RouteParamsInterface {
    id: string;
}

interface ResponseRouteChecklistPut extends ResponseRouteChecklistGet {}

export {
    locationRestChecklistPut,
    type RequestRouteChecklistPut,
    type ParamsRouteChecklistPut,
    type ResponseRouteChecklistPut,
};
