import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestConsentDelete: RouteLocationInterface = {
    path: "/consent/:id",
    method: RouteHttpVerb.DELETE,
};

interface RequestRouteConsentDelete extends RouteRequestInterface {}

interface ParamsRouteConsentDelete extends RouteParamsInterface {
    id: number;
}

interface ResponseRouteConsentDelete extends RouteResponseInterface {}

export {
    locationRestConsentDelete,
    type RequestRouteConsentDelete,
    type ParamsRouteConsentDelete,
    type ResponseRouteConsentDelete,
};
