import type { BannerHistoryEntry } from "@devowl-wp/react-cookie-banner";
import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestConsentGet: RouteLocationInterface = {
    path: "/consent",
    method: RouteHttpVerb.GET,
    obfuscatePath: "keep-last-part",
};

interface RequestRouteConsentGet extends RouteRequestInterface {}

interface ParamsRouteConsentGet extends RouteParamsInterface {}

type ResponseRouteConsentGet = RouteResponseInterface & Array<BannerHistoryEntry>;

export {
    locationRestConsentGet,
    type RequestRouteConsentGet,
    type ParamsRouteConsentGet,
    type ResponseRouteConsentGet,
};
