import type { ConsentCommit, ConsentTransaction } from "@devowl-wp/cookie-consent-management";
import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestConsentPost: RouteLocationInterface = {
    path: "/consent",
    method: RouteHttpVerb.POST,
    obfuscatePath: "keep-last-part",
};

type RequestRouteConsentPost = RouteRequestInterface & ConsentTransaction;

interface ParamsRouteConsentPost extends RouteParamsInterface {}

type ResponseRouteConsentPost = RouteResponseInterface & ConsentCommit["response"];

export {
    locationRestConsentPost,
    type RequestRouteConsentPost,
    type ParamsRouteConsentPost,
    type ResponseRouteConsentPost,
};
