import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestConsentAllDelete: RouteLocationInterface = {
    path: "/consent/all",
    method: RouteHttpVerb.DELETE,
};

interface RequestRouteConsentAllDelete extends RouteRequestInterface {}

interface ParamsRouteConsentAllDelete extends RouteParamsInterface {}

interface ResponseRouteConsentAllDelete extends RouteResponseInterface {
    consent: number | false;
    revision: number | false;
    revision_independent: number | false;
    stats_terms: number | false;
    stats_buttons_clicked: number | false;
    stats_custom_bypass: number | false;
}

export {
    locationRestConsentAllDelete,
    type RequestRouteConsentAllDelete,
    type ParamsRouteConsentAllDelete,
    type ResponseRouteConsentAllDelete,
};
