import type { ClickableButtonsNamed, DecisionConsentGroups } from "@devowl-wp/cookie-consent-web-client";
import type { CommonContextProps } from "@devowl-wp/react-cookie-banner";
import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

import type { RequestRouteConsentPost } from "./consent.post.js";
import type { BlockerDefinition } from "../types/blocker.js";

const locationRestConsentAllGet: RouteLocationInterface = {
    path: "/consent/all",
    method: RouteHttpVerb.GET,
};

interface RequestRouteConsentAllGet extends RouteRequestInterface {}

interface ParamsRouteConsentAllGet extends RouteParamsInterface {
    offset: number;
    context?: string;
    from?: string;
    to?: string;
    per_page?: number;
    uuid?: string;
    ip?: string;
    referer?: string;
}

interface ResponseRouteConsentAllGetEntity {
    id: number;
    plugin_version: string;
    design_version: CommonContextProps["designVersion"];
    ipv4?: string;
    ipv6?: string;
    ipv4_hash: string;
    ipv6_hash: string;
    uuid: string;
    previous_decision?: DecisionConsentGroups;
    decision: DecisionConsentGroups;
    decision_labels: string[];
    created: string;
    dnt: boolean;
    custom_bypass?: "geolocation";
    user_country?: string;
    blocker?: number;
    blocker_thumbnail?: BlockerDefinition["visualThumbnail"] & {
        id: number;
    };
    revision_hash: string;
    revision_independent_hash: string;
    button_clicked: ClickableButtonsNamed;
    context: string;
    viewport_width: number;
    viewport_height: number;
    referer: string;
    url_imprint: string;
    url_privacy_policy: string;
    forwarded?: number;
    forwarded_blocker: boolean;
    previous_tcf_string?: string;
    tcf_string?: string;
    previous_gcm_consent?: CommonContextProps["gcmConsent"];
    gcm_consent?: CommonContextProps["gcmConsent"];
    recorder?: string;
    ui_view?: RequestRouteConsentPost["uiView"];
}

interface ResponseRouteConsentAllGet extends RouteResponseInterface {
    count: number;
    /**
     * This property is only available for the first page (`offset=0`).
     */
    truncatedIpsCount?: number;
    items: ResponseRouteConsentAllGetEntity[];
}

export {
    locationRestConsentAllGet,
    type RequestRouteConsentAllGet,
    type ParamsRouteConsentAllGet,
    type ResponseRouteConsentAllGetEntity,
    type ResponseRouteConsentAllGet,
};
