import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestConsentClearDelete: RouteLocationInterface = {
    path: "/consent/clear",
    method: RouteHttpVerb.DELETE,
    obfuscatePath: "keep-last-part",
};

interface RequestRouteConsentClearDelete extends RouteRequestInterface {}

interface ParamsRouteConsentClearDelete extends RouteParamsInterface {
    cookies: string;
}

interface ResponseRouteConsentClearDelete extends RouteResponseInterface {}

export {
    locationRestConsentClearDelete,
    type RequestRouteConsentClearDelete,
    type ParamsRouteConsentClearDelete,
    type ResponseRouteConsentClearDelete,
};
