import type { PreDecisionGatewayResult } from "@devowl-wp/cookie-consent-web-client";
import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestConsentDynamicPredecisionGet: RouteLocationInterface = {
    path: "/consent/dynamic-predecision",
    method: RouteHttpVerb.POST,
    obfuscatePath: "keep-last-part",
};

interface RequestRouteConsentDynamicPredecisionGet extends RouteRequestInterface {
    viewPortWidth: number;
    viewPortHeight: number;
    tcfStringImplicitEssentials: string;
    referer: string;
}

interface ParamsRouteConsentDynamicPredecisionGet extends RouteParamsInterface {}

interface ResponseRouteConsentDynamicPredecisionGet extends RouteResponseInterface {
    predecision: false | PreDecisionGatewayResult;
    calculationTimeSeconds: number;
}

export {
    locationRestConsentDynamicPredecisionGet,
    type RequestRouteConsentDynamicPredecisionGet,
    type ParamsRouteConsentDynamicPredecisionGet,
    type ResponseRouteConsentDynamicPredecisionGet,
};
