import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestCookieGroupOrderPut: RouteLocationInterface = {
    path: "/cookie-groups/order",
    method: RouteHttpVerb.PUT,
};

interface RequestRouteCookieGroupOrderPut extends RouteRequestInterface {
    ids: number[];
}

interface ParamsRouteCookieGroupOrderPut extends RouteParamsInterface {}

interface ResponseRouteCookieGroupOrderPut extends RouteResponseInterface {}

export {
    locationRestCookieGroupOrderPut,
    type RequestRouteCookieGroupOrderPut,
    type ParamsRouteCookieGroupOrderPut,
    type ResponseRouteCookieGroupOrderPut,
};
