import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestCookieUnassignedGet: RouteLocationInterface = {
    path: "/cookies/unassigned",
    method: RouteHttpVerb.GET,
};

interface RequestRouteCookieUnassignedGet extends RouteRequestInterface {}

interface ParamsRouteCookieUnassignedGet extends RouteParamsInterface {}

type ResponseRouteCookieUnassignedGet = RouteResponseInterface &
    Array<{
        id: number;
        title: string;
    }>;

export {
    locationRestCookieUnassignedGet,
    type RequestRouteCookieUnassignedGet,
    type ParamsRouteCookieUnassignedGet,
    type ResponseRouteCookieUnassignedGet,
};
