import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestCookiesOrderPut: RouteLocationInterface = {
    path: "/cookies/order",
    method: RouteHttpVerb.PUT,
};

interface RequestRouteCookiesOrderPut extends RouteRequestInterface {
    ids: number[];
}

interface ParamsRouteCookiesOrderPut extends RouteParamsInterface {}

interface ResponseRouteCookiesOrderPut extends RouteResponseInterface {}

export {
    locationRestCookiesOrderPut,
    type RequestRouteCookiesOrderPut,
    type ParamsRouteCookiesOrderPut,
    type ResponseRouteCookiesOrderPut,
};
