import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

import type { ResponseRouteRevisionGet } from "./revision.get.js";

const locationRestExportGet: RouteLocationInterface = {
    path: "/export",
    method: RouteHttpVerb.GET,
};

interface RequestRouteExportGet extends RouteRequestInterface {}

interface ParamsRouteExportGet extends RouteParamsInterface {
    download?: boolean;
    settings?: boolean;
    cookieGroups?: boolean;
    cookies?: boolean;
    blocker?: boolean;
    customizeBanner?: boolean;
}

// The interface is not fully typed because it is generic in frontend and only consumed in backend
interface ResponseRouteExportGet extends RouteResponseInterface {
    settings?: ResponseRouteRevisionGet["options"];
    cookieGroups?: any[];
    cookies?: any[];
    blocker?: any[];
    customizeBanner?: any;
}

export { locationRestExportGet, type RequestRouteExportGet, type ParamsRouteExportGet, type ResponseRouteExportGet };
