import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestExportConsentsGet: RouteLocationInterface = {
    path: "/export/consents",
    method: RouteHttpVerb.GET,
};

interface RequestRouteExportConsentsGet extends RouteRequestInterface {}

interface ParamsRouteExportConsentsGet extends RouteParamsInterface {
    uuid?: string;
    from?: string;
    to?: string;
}

interface ResponseRouteExportConsentsGet extends RouteResponseInterface {}

export {
    locationRestExportConsentsGet,
    type RequestRouteExportConsentsGet,
    type ParamsRouteExportConsentsGet,
    type ResponseRouteExportConsentsGet,
};
