import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

import type { CookieMeta } from "../types/cookie.js";

const locationRestForwardCookieGet: RouteLocationInterface = {
    path: "/forward/cookie/:slug",
    method: RouteHttpVerb.GET,
};

interface RequestRouteForwardCookieGet extends RouteRequestInterface {}

interface ParamsRouteForwardCookieGet extends RouteParamsInterface {
    slug: string;
}

type ResponseRouteForwardCookieGet = RouteResponseInterface &
    Array<{
        [key: string]: any;
        metas: CookieMeta;
        ID: number;
    }>;

export {
    locationRestForwardCookieGet,
    type RequestRouteForwardCookieGet,
    type ParamsRouteForwardCookieGet,
    type ResponseRouteForwardCookieGet,
};
