import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestForwardEndpointsGet: RouteLocationInterface = {
    path: "/forward/endpoints",
    method: RouteHttpVerb.GET,
};

interface RequestRouteForwardEndpointsGet extends RouteRequestInterface {}

interface ParamsRouteForwardEndpointsGet extends RouteParamsInterface {
    filter?: "all" | "notCurrent" | "onlyCurrent";
}

interface ResponseRouteForwardEndpointsGet extends RouteResponseInterface {
    [url: string]: string;
}

export {
    locationRestForwardEndpointsGet,
    type RequestRouteForwardEndpointsGet,
    type ParamsRouteForwardEndpointsGet,
    type ResponseRouteForwardEndpointsGet,
};
