import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestImportPost: RouteLocationInterface = {
    path: "/import",
    method: RouteHttpVerb.POST,
};

type ImportStati = "keep" | "publish" | "private" | "draft";

interface RequestRouteImportPost extends RouteRequestInterface {
    json: string;
    cookieGroup: number;
    cookieStatus: ImportStati;
    cookieSkipExisting: boolean;
    blockerStatus: ImportStati;
    blockerSkipExisting: boolean;
    tcfVendorConfigurationStatus: ImportStati;
}

interface ParamsRouteImportPost extends RouteParamsInterface {}

interface ResponseRouteImportPost extends RouteResponseInterface {
    messages: Array<{
        message: string;
        severity: "error" | "warning" | "info";
        fix?: "settings" | "cookieDuplicate" | "cookie" | "blockerDuplicate" | "blocker" | "link";
        // Only for fix: setting
        settingsTab?: "" | "consent" | "multisite";
        // Only for fix: cookieDuplicate
        cookieDuplicate?: {
            // groupId, postId
            original: [number, number];
            duplicate: [number, number];
        };
        // Only for fix: cookie
        cookie?: [number, number];
        // Only for fix: blockerDuplicate
        blockerDuplicate?: {
            original: number;
            duplicate: number;
        };
        // Only for fix: blocker
        blocker?: [number, number];
        // Only for fix: link
        href?: string;
        linkText?: string;
    }>;
}

export {
    locationRestImportPost,
    type RequestRouteImportPost,
    type ParamsRouteImportPost,
    type ResponseRouteImportPost,
};
