import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestMigrationDelete: RouteLocationInterface = {
    path: "/migration/:migration",
    method: RouteHttpVerb.DELETE,
};

interface RequestRouteMigrationDelete extends RouteRequestInterface {}

interface ParamsRouteMigrationDelete extends RouteParamsInterface {
    migration: string;
}

interface ResponseRouteMigrationDelete extends RouteResponseInterface {
    success: boolean;
}

export {
    locationRestMigrationDelete,
    type RequestRouteMigrationDelete,
    type ParamsRouteMigrationDelete,
    type ResponseRouteMigrationDelete,
};
