import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

import type { DashboardTileMigration } from "../components/config/dashboard/migration.js";

const locationRestMigrationPost: RouteLocationInterface = {
    path: "/migration/:migration/:action",
    method: RouteHttpVerb.POST,
};

interface RequestRouteMigrationPost extends RouteRequestInterface {}

interface ParamsRouteMigrationPost extends RouteParamsInterface {
    migration: string;
    action: string;
}

interface ResponseRouteMigrationPost extends RouteResponseInterface {
    success: boolean;
    redirect?: string;
    message?: string;
    overrideAction?: Partial<DashboardTileMigration["actions"][""]>;
}

export {
    locationRestMigrationPost,
    type RequestRouteMigrationPost,
    type ParamsRouteMigrationPost,
    type ResponseRouteMigrationPost,
};
