import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

import type { BannerPreset } from "../models/bannerPreset.js";

const locationRestPresetsBannerGet: RouteLocationInterface = {
    path: "/presets/banner",
    method: RouteHttpVerb.GET,
};

interface RequestRoutePresetsBannerGet extends RouteRequestInterface {}

interface ParamsRoutePresetsBannerGet extends RouteParamsInterface {}

interface ResponseRoutePresetsBannerGet extends RouteResponseInterface {
    constants: {
        [key: string]: string;
    };
    defaults: {
        [key: string]: any;
    };
    items: {
        [key: string]: Partial<BannerPreset>;
    };
}

export {
    locationRestPresetsBannerGet,
    type RequestRoutePresetsBannerGet,
    type ParamsRoutePresetsBannerGet,
    type ResponseRoutePresetsBannerGet,
};
