import type { Revision } from "@devowl-wp/cookie-consent-management";
import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestRevisionGet: RouteLocationInterface = {
    path: "/revision/:hash",
    method: RouteHttpVerb.GET,
};

interface RequestRouteRevisionGet extends RouteRequestInterface {}

interface ParamsRouteRevisionGet extends RouteParamsInterface {
    hash: string;
}

type ResponseRouteRevisionGet = RouteResponseInterface & Revision;

export {
    locationRestRevisionGet,
    type RequestRouteRevisionGet,
    type ParamsRouteRevisionGet,
    type ResponseRouteRevisionGet,
};
