import type { FormServiceContext, FormSettingsContext, UpsellContext } from "@devowl-wp/react-cookie-banner-admin";
import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

import type { DashboardTileMigration } from "../components/config/dashboard/migration.js";

const locationRestRevisionCurrentGet: RouteLocationInterface = {
    path: "/revision/current",
    method: RouteHttpVerb.GET,
};

interface RequestRouteRevisionCurrentGet extends RouteRequestInterface {}

interface ParamsRouteRevisionCurrentGet extends RouteParamsInterface {}

interface ResponseRouteRevisionCurrentGet extends RouteResponseInterface {
    public_to_users: string;
    contexts: Record<string, string>;
    calculated: string;
    needs_retrigger: boolean;
    services_data_processing_in_unsafe_countries_notice_html: null | string;
    services_with_empty_privacy_policy_notice_html: null | string;
    created_tag_managers: FormServiceContext["initialState"]["createdTagManagers"];
    public_cookie_count: number;
    all_cookie_count: number;
    all_blocker_count: number;
    all_tcf_vendor_configuration_count: number;
    all_scanner_result_templates_count: number;
    all_scanner_result_external_urls_count: number;
    template_needs_update: Array<{
        post_id: number;
        post_template_identifier: string;
        post_template_version: number;
        post_title: string;
        post_type: string;
        post_version_meta_id: number;
        should: number;
    }>;
    template_update_notice_html?: string;
    check_saving_consent_via_rest_api_endpoint_working_html?: string;
    template_successors_notice_html?: string;
    google_consent_mode_notices_html: string[];
    cookie_counts: {
        [key: string]: number;
        draft: number;
        publish: number;
        private: number;
    };
    cloud_release_info: Record<
        "blocker" | "service",
        null | {
            downloadTime: string;
            releaseId: number;
            isPreReleaseEnabled: boolean;
        }
    >;
    consents_deleted_at: string;
    bannerless_consent_checks: FormSettingsContext["initialState"]["bannerlessConsentChecks"];
    nav_menus: Array<
        | {
              id: string;
              type: "legacy_nav";
              term_id: number;
              applied: boolean;
              languages: Array<{
                  code: string;
                  language: string;
                  location: string;
              }>;
              locations: Record<string, string>;
              name: string;
              edit_url: string;
          }
        | {
              id: string;
              type: "nav_menu";
              post_id: number;
              applied: boolean;
              languages: Array<{
                  code: string;
                  language: string;
                  location: string;
              }>;
              name: string;
              edit_url: string;
          }
    >;
    tcf_vendor_configuration_counts: ResponseRouteRevisionCurrentGet["cookie_counts"];
    dashboard_migration?: DashboardTileMigration;
    /**
     * Only available in free version.
     */
    fomo_coupon?: UpsellContext["contextValue"]["fomoCoupon"];
}

export {
    locationRestRevisionCurrentGet,
    type RequestRouteRevisionCurrentGet,
    type ParamsRouteRevisionCurrentGet,
    type ResponseRouteRevisionCurrentGet,
};
