import type { RevisionIndependent } from "@devowl-wp/cookie-consent-management";
import type { Customize } from "@devowl-wp/react-cookie-banner";
import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestRevisionIndependentGet: RouteLocationInterface = {
    path: "/revision/independent/:hash",
    method: RouteHttpVerb.GET,
};

interface RequestRouteRevisionIndependentGet extends RouteRequestInterface {}

interface ParamsRouteRevisionIndependentGet extends RouteParamsInterface {
    hash: string;
}

type ResponseRouteRevisionIndependentGet = RouteResponseInterface &
    RevisionIndependent<{
        banner: {
            customizeValuesBanner: Customize;
        };
        isPro: boolean;
        isLicensed: boolean;
        isDevLicense: boolean;
    }>;

export {
    locationRestRevisionIndependentGet,
    type RequestRouteRevisionIndependentGet,
    type ParamsRouteRevisionIndependentGet,
    type ResponseRouteRevisionIndependentGet,
};
