import type { LazyDataForSecondView } from "@devowl-wp/react-cookie-banner";
import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestRevisionSecondView: RouteLocationInterface = {
    path: "/revision/second-view",
    method: RouteHttpVerb.GET,
    obfuscatePath: "keep-last-part",
};

interface RequestRouteRevisionSecondView extends RouteRequestInterface {}

interface ParamsRouteRevisionSecondView extends RouteParamsInterface {
    /**
     * Pass the revision hash to bypass caching of REST endpoint.
     */
    revisionHash?: string;
}

type ResponseRouteRevisionSecondView = RouteResponseInterface & LazyDataForSecondView;

export {
    locationRestRevisionSecondView,
    type RequestRouteRevisionSecondView,
    type ParamsRouteRevisionSecondView,
    type ResponseRouteRevisionSecondView,
};
