import type { RouteLocationInterface, RouteRequestInterface, RouteResponseInterface } from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

import type { ParamsRouteStatsButtonsClickedGet } from "./statsButtonsClicked.js";

const locationRestScannerQueuePost: RouteLocationInterface = {
    path: "/scanner/queue",
    method: RouteHttpVerb.POST,
};

interface RequestRouteScannerQueuePost extends RouteRequestInterface {
    urls: string[];
    purgeUnused?: boolean;
}

interface ParamsRouteScannerQueuePost extends ParamsRouteStatsButtonsClickedGet {}

interface ResponseRouteScannerQueuePost extends RouteResponseInterface {
    added: number;
}

export {
    locationRestScannerQueuePost,
    type RequestRouteScannerQueuePost,
    type ParamsRouteScannerQueuePost,
    type ResponseRouteScannerQueuePost,
};
