import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestScannerResultIgnorePost: RouteLocationInterface = {
    path: "/scanner/result/ignore",
    method: RouteHttpVerb.POST,
};

interface RequestRouteScannerResultIgnorePost extends RouteRequestInterface {
    type: "template" | "host";
    value: string;
    ignored: boolean;
}

interface ParamsRouteScannerResultIgnorePost extends RouteParamsInterface {}

interface ResponseRouteScannerResultIgnorePost extends RouteResponseInterface {
    updated: boolean;
}

export {
    locationRestScannerResultIgnorePost,
    type RequestRouteScannerResultIgnorePost,
    type ParamsRouteScannerResultIgnorePost,
    type ResponseRouteScannerResultIgnorePost,
};
