import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestScannerResultAllExternalUrlsByHostGet: RouteLocationInterface = {
    path: "/scanner/result/externals/:type/:identifier",
    method: RouteHttpVerb.GET,
    obfuscatePath: "full",
};

interface RequestRouteScannerResultAllExternalUrls extends RouteRequestInterface {}

interface ParamsRouteScannerResultAllExternalUrls extends RouteParamsInterface {
    type: "template" | "host";
    identifier: string;
}

interface ResponseRouteScannerResultAllExternalUrls extends RouteResponseInterface {
    items: Array<{
        id: number;
        blockedUrl: string;
        markup: boolean;
        sourceUrl: string;
        blocked: boolean;
        ignored: boolean;
        lastScanned: string;
        tag: string;
    }>;
}

export {
    locationRestScannerResultAllExternalUrlsByHostGet,
    type RequestRouteScannerResultAllExternalUrls,
    type ParamsRouteScannerResultAllExternalUrls,
    type ResponseRouteScannerResultAllExternalUrls,
};
