import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestScannerResultExternalsGet: RouteLocationInterface = {
    path: "/scanner/result/externals",
    method: RouteHttpVerb.GET,
};

interface RequestRouteScannerResultExternalsGet extends RouteRequestInterface {}

interface ParamsRouteScannerResultExternalsGet extends RouteParamsInterface {}

interface ResponseRouteScannerResultExternalsGet extends RouteResponseInterface {
    items: {
        [key: string]: {
            host: string;
            foundCount: number;
            foundOnSitesCount: number;
            blockedCount: number;
            ignored: boolean;
            lastScanned: string;
            tags: string[];
        };
    };
}

export {
    locationRestScannerResultExternalsGet,
    type RequestRouteScannerResultExternalsGet,
    type ParamsRouteScannerResultExternalsGet,
    type ResponseRouteScannerResultExternalsGet,
};
