import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestScannerResultMarkupGet: RouteLocationInterface = {
    path: "/scanner/result/markup/:id",
    method: RouteHttpVerb.GET,
};

interface RequestRouteScannerResultMarkupGet extends RouteRequestInterface {}

interface ParamsRouteScannerResultMarkupGet extends RouteParamsInterface {
    id: number;
}

interface ResponseRouteScannerResultMarkupGet extends RouteResponseInterface {
    id: number;
    tag: string;
    mime: string;
    markup: string;
    markup_hash: string;
}

export {
    locationRestScannerResultMarkupGet,
    type RequestRouteScannerResultMarkupGet,
    type ParamsRouteScannerResultMarkupGet,
    type ResponseRouteScannerResultMarkupGet,
};
