import type { ClientBlockerTemplate, ClientServiceTemplate } from "@devowl-wp/service-cloud-consumer";
import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestScannerResultTemplatesGet: RouteLocationInterface = {
    path: "/scanner/result/templates",
    method: RouteHttpVerb.GET,
};

interface RequestRouteScannerResultTemplatesGet extends RouteRequestInterface {}

interface ParamsRouteScannerResultTemplatesGet extends RouteParamsInterface {}

interface ResponseRouteScannerResultTemplatesGet extends RouteResponseInterface {
    items: Array<ClientServiceTemplate["afterPersist"] | ClientBlockerTemplate["afterPersist"]>;
}

export {
    locationRestScannerResultTemplatesGet,
    type RequestRouteScannerResultTemplatesGet,
    type ParamsRouteScannerResultTemplatesGet,
    type ResponseRouteScannerResultTemplatesGet,
};
