import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestScannerScanWithoutLoginGet: RouteLocationInterface = {
    path: "/scanner/scan-without-login",
    namespace: "real-cookie-banner/v1",
    method: RouteHttpVerb.GET,
};

interface RequestRouteScannerScanWithoutLoginGet extends RouteRequestInterface {}

interface ParamsRouteScannerScanWithoutLoginGet extends RouteParamsInterface {
    url: string;
    jobId: number;
}

interface ResponseRouteScannerScanWithoutLoginGet extends RouteResponseInterface {
    status: number;
    ok: boolean;
    statusText: string;
    headers: Record<string, string>;
    redirected: boolean;
    responseUrl: string;
    body: string;
}

export {
    locationRestScannerScanWithoutLoginGet,
    type RequestRouteScannerScanWithoutLoginGet,
    type ParamsRouteScannerScanWithoutLoginGet,
    type ResponseRouteScannerScanWithoutLoginGet,
};
