import type { TcfScope } from "@devowl-wp/cookie-consent-web-client";
import type { Customize } from "@devowl-wp/react-cookie-banner";
import type { FormSettingsValueProps } from "@devowl-wp/react-cookie-banner-admin";
import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestSettings: RouteLocationInterface = {
    path: "/settings",
    method: RouteHttpVerb.GET,
};

interface RequestRouteSettings extends RouteRequestInterface {}

interface ParamsRouteSettings extends RouteParamsInterface {}

interface ResponseRouteSettings extends RouteResponseInterface {
    "rcb-accept-all-for-bots": FormSettingsValueProps["isAcceptAllForBots"];
    "rcb-banner-active": FormSettingsValueProps["isBannerActive"];
    "rcb-blocker-active": FormSettingsValueProps["isBlockerActive"];
    "rcb-cookie-duration": FormSettingsValueProps["cookieDuration"];
    // Saved serialize as WordPress < 5.3 does not support `string[]`
    "rcb-hide-page-ids": string;
    "rcb-respect-do-not-track": FormSettingsValueProps["isRespectDoNotTrack"];
    "rcb-banner-less-consent": FormSettingsValueProps["isBannerLessConsent"];
    // Saved serialize as WordPress < 5.3 does not support `string[]`
    "rcb-banner-less-show-on-page-ids": string;
    "rcb-failed-consent-documentation-handling": FormSettingsValueProps["failedConsentDocumentationHandling"];
    "rcb-save-ip": FormSettingsValueProps["isSaveIp"];
    "rcb-data-processing-in-unsafe-countries": FormSettingsValueProps["isDataProcessingInUnsafeCountries"];
    // Saved serialize as WordPress < 5.3 does not support `string[]`
    "rcb-data-processing-in-unsafe-countries-safe-countries": string;
    "rcb-age-notice": FormSettingsValueProps["isAgeNotice"];
    "rcb-age-notice-age-limit": FormSettingsValueProps["ageNoticeAgeLimit"];
    "rcb-list-services-notice": FormSettingsValueProps["isListServicesNotice"];
    "rcb-set-cookies-via-manager": FormSettingsValueProps["setCookiesViaManager"];
    "rcb-operator-country": FormSettingsValueProps["operatorCountry"];
    "rcb-operator-contact-address": FormSettingsValueProps["operatorContactAddress"];
    "rcb-operator-contact-email": FormSettingsValueProps["operatorContactEmail"];
    "rcb-operator-contact-phone": FormSettingsValueProps["operatorContactPhone"];
    "rcb-operator-contact-form-id": FormSettingsValueProps["operatorContactFormId"];
    "rcb-cookie-policy-id": FormSettingsValueProps["cookiePolicyId"];
    // Saved serialize as WordPress < 5.3 does not support `string[]`
    "rcb-territorial-legal-basis": string;
    "rcb-consent-forwarding": FormSettingsValueProps["isConsentForwarding"];
    // Saved serialize as WordPress < 5.3 does not support `string[]`
    "rcb-forward-to": string;
    "rcb-cross-domains": FormSettingsValueProps["crossDomains"];
    "rcb-affiliate-link": FormSettingsValueProps["affiliateLink"];
    "rcb-affiliate-label-behind": FormSettingsValueProps["affiliateLabelBehind"];
    "rcb-affiliate-description": FormSettingsValueProps["affiliateLabelDescription"];
    "rcb-country-bypass"?: FormSettingsValueProps["isCountryBypass"];
    // Saved serialize as WordPress < 5.3 does not support `string[]`
    "rcb-country-bypass-countries"?: string;
    "rcb-country-bypass-type"?: FormSettingsValueProps["countryBypassType"];
    "rcb-country-bypass-db-download-time"?: string;
    "rcb-tcf"?: FormSettingsValueProps["isTcf"];
    "rcb-tcf-accepted-time"?: string;
    "rcb-tcf-gvl-download-time"?: string;
    /**
     * @deprecated No longer in use
     */
    "rcb-tcf-scope-of-consent"?: TcfScope;
    "rcb-gcm"?: FormSettingsValueProps["isGcm"];
    "rcb-gcm-additional-url-parameters"?: FormSettingsValueProps["isGcmCollectAdditionalDataViaUrlParameters"];
    "rcb-gcm-recommandations"?: FormSettingsValueProps["isGcmShowRecommandationsWithoutConsent"];
    "rcb-gcm-redact-without-consent"?: FormSettingsValueProps["isGcmRedactAdsDataWithoutConsent"];
    "rcb-gcm-list-purposes"?: FormSettingsValueProps["isGcmListPurposes"];
    "rcb-consent-duration": FormSettingsValueProps["consentDuration"];
    "rcb-banner-sticky-links-enabled"?: Customize["sticky"]["enabled"];
}

export { locationRestSettings, type RequestRouteSettings, type ParamsRouteSettings, type ResponseRouteSettings };
