import type { ClickableButtonsNamed } from "@devowl-wp/cookie-consent-web-client";
import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestStatsButtonsClickedGet: RouteLocationInterface = {
    path: "/stats/buttonsClicked",
    method: RouteHttpVerb.GET,
};

interface RequestRouteStatsButtonsClickedGet extends RouteRequestInterface {}

interface ParamsRouteStatsButtonsClickedGet extends RouteParamsInterface {
    from: string;
    to: string;
    context: string;
}

type ResponseRouteStatsButtonsClickedGet = RouteResponseInterface & {
    [key in ClickableButtonsNamed]: [string, number];
};

export {
    locationRestStatsButtonsClickedGet,
    type RequestRouteStatsButtonsClickedGet,
    type ParamsRouteStatsButtonsClickedGet,
    type ResponseRouteStatsButtonsClickedGet,
};
