import type { RouteLocationInterface, RouteRequestInterface, RouteResponseInterface } from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

import type { ParamsRouteStatsButtonsClickedGet } from "./statsButtonsClicked.js";

const locationRestStatsMainGet: RouteLocationInterface = {
    path: "/stats/main",
    method: RouteHttpVerb.GET,
};

interface RequestRouteStatsMainGet extends RouteRequestInterface {}

interface ParamsRouteStatsMainGet extends ParamsRouteStatsButtonsClickedGet {}

type ResponseRouteStatsMainGetEntry = {
    term_name: string;
    accepted: /* None */ "0" | /* Partial */ "1" | /* All */ "2";
    count: number;
};

type ResponseRouteStatsMainGet = RouteResponseInterface & Array<ResponseRouteStatsMainGetEntry>;

export {
    locationRestStatsMainGet,
    type RequestRouteStatsMainGet,
    type ParamsRouteStatsMainGet,
    type ResponseRouteStatsMainGetEntry,
    type ResponseRouteStatsMainGet,
};
