import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

import type { Declarations, VendorList } from "@iabtechlabtcf/core";

const locationRestTcfDeclarationsGet: RouteLocationInterface = {
    path: "/tcf/declarations",
    method: RouteHttpVerb.GET,
};

interface RequestRouteTcfDeclarationsGet extends RouteRequestInterface {}

interface ParamsRouteTcfDeclarationsGet extends RouteParamsInterface {}

type ResponseRouteTcfDeclarationsGet = RouteResponseInterface &
    Omit<
        Declarations,
        | "vendors"
        // Currently not exposed by this API, as they are calculated on the fly
        | "stacks"
    > & {
        gvlSpecificationVersion: VendorList["gvlSpecificationVersion"];
        tcfPolicyVersion: VendorList["tcfPolicyVersion"];
    };

export {
    locationRestTcfDeclarationsGet,
    type RequestRouteTcfDeclarationsGet,
    type ParamsRouteTcfDeclarationsGet,
    type ResponseRouteTcfDeclarationsGet,
};
