import type { ITcfVendorList } from "@devowl-wp/api-real-cookie-banner";
import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

import type { IntMap, Vendor, VendorList } from "@iabtechlabtcf/core";

const locationRestTcfVendorsGet: RouteLocationInterface = {
    path: "/tcf/vendors",
    method: RouteHttpVerb.GET,
};

interface RequestRouteTcfVendorsGet extends RouteRequestInterface {}

interface ParamsRouteTcfVendorsGet extends RouteParamsInterface {}

interface ResponseRouteTcfVendorsGet extends RouteResponseInterface {
    vendorListVersion: VendorList["vendorListVersion"];
    vendors: IntMap<
        Vendor &
            Pick<
                ITcfVendorList["composedVendorList"]["vendors"][""],
                "deviceStorageDisclosure" | "additionalInformation" | "deviceStorageDisclosureViolation"
            >
    >;
}

export {
    locationRestTcfVendorsGet,
    type RequestRouteTcfVendorsGet,
    type ParamsRouteTcfVendorsGet,
    type ResponseRouteTcfVendorsGet,
};
