import type { ClientBlockerTemplate } from "@devowl-wp/service-cloud-consumer";
import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestTemplatesBlockersGet: RouteLocationInterface = {
    path: "/templates/blocker",
    method: RouteHttpVerb.GET,
};

interface RequestRouteTemplatesBlockersGet extends RouteRequestInterface {}

interface ParamsRouteTemplatesBlockersGet extends RouteParamsInterface {
    storage?: "use" | "invalidate" | "redownload";
}

interface ResponseRouteTemplatesBlockersGet extends RouteResponseInterface {
    items: ClientBlockerTemplate["afterPersist"][];
}

export {
    locationRestTemplatesBlockersGet,
    type RequestRouteTemplatesBlockersGet,
    type ParamsRouteTemplatesBlockersGet,
    type ResponseRouteTemplatesBlockersGet,
};
