import type { ClientBlockerTemplate } from "@devowl-wp/service-cloud-consumer";
import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestTemplatesBlockerUseGet: RouteLocationInterface = {
    path: "/templates/blocker/:identifier",
    method: RouteHttpVerb.GET,
    obfuscatePath: "full",
};

interface RequestRouteTemplatesBlockerUseGet extends RouteRequestInterface {}

interface ParamsRouteTemplatesBlockerUseGet extends RouteParamsInterface {
    identifier: string;
}

type ResponseRouteTemplatesBlockerUseGet = RouteResponseInterface & ClientBlockerTemplate["use"];

export {
    locationRestTemplatesBlockerUseGet,
    type RequestRouteTemplatesBlockerUseGet,
    type ParamsRouteTemplatesBlockerUseGet,
    type ResponseRouteTemplatesBlockerUseGet,
};
