import type { ClientServiceTemplate } from "@devowl-wp/service-cloud-consumer";
import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestTemplatesServiceUseGet: RouteLocationInterface = {
    path: "/templates/services/:identifier",
    method: RouteHttpVerb.GET,
    obfuscatePath: "full",
};

interface RequestRouteTemplatesServiceUseGet extends RouteRequestInterface {}

interface ParamsRouteTemplatesServiceUseGet extends RouteParamsInterface {
    identifier: string;
}

type ResponseRouteTemplatesServiceUseGet = RouteResponseInterface & ClientServiceTemplate["use"];

export {
    locationRestTemplatesServiceUseGet,
    type RequestRouteTemplatesServiceUseGet,
    type ParamsRouteTemplatesServiceUseGet,
    type ResponseRouteTemplatesServiceUseGet,
};
