import type { ClientServiceTemplate } from "@devowl-wp/service-cloud-consumer";
import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestTemplatesServicesGet: RouteLocationInterface = {
    path: "/templates/services",
    method: RouteHttpVerb.GET,
};

interface RequestRouteTemplatesServicesGet extends RouteRequestInterface {}

interface ParamsRouteTemplatesServicesGet extends RouteParamsInterface {
    storage?: "use" | "invalidate" | "redownload";
}

interface ResponseRouteTemplatesServicesGet extends RouteResponseInterface {
    items: ClientServiceTemplate["afterPersist"][];
}

export {
    locationRestTemplatesServicesGet,
    type RequestRouteTemplatesServicesGet,
    type ParamsRouteTemplatesServicesGet,
    type ResponseRouteTemplatesServicesGet,
};
