/* v8 ignore start */
// we do not need to care about the entry point file as errors are detected through integration tests (E2E)

/**
 * The entry point for the admin side wp-admin resource.
 */
import "./style/admin.scss";
import $ from "jquery";

import { handleCorruptRestApi } from "@devowl-wp/utils";

import { FirstTimePointer } from "./others/postsTable/firstTimePointer.js";
import { TABLE_BODY_SELECTOR, applyPostsTableSortable } from "./others/postsTable/postsTable.js";
import { RootStore } from "./store/stores.js";
import { request } from "./utils/request.js";

handleCorruptRestApi({
    [RootStore.get.optionStore.restNamespace]: async () => {
        await request({
            location: {
                path: "/plugin",
            },
        });
    },
});

applyPostsTableSortable();

// RCM compatibility (fast mode)
$(document).ajaxComplete(() => {
    setTimeout(applyPostsTableSortable, 200); // avoid RC
});

// Show the first-time-pointer only once for each list entry
RootStore.get.optionStore.others.types.post.showPostFirstTimePointer &&
    setTimeout(() => {
        let showFirstTimePointer = true;
        $(document).one("mouseenter", `${TABLE_BODY_SELECTOR} > tr`, function () {
            showFirstTimePointer && new FirstTimePointer($(this));
            showFirstTimePointer = false;
        });
    }, 1000); // Unfortunately, we need a delay due to page load

// Expose this functionalities to add-ons, but you need to activate the library functionality
// in your webpack configuration, see also https://webpack.js.org/guides/author-libraries/
export * from "@devowl-wp/utils";
export * from "./wp-api/index.js";
export * from "./store/index.js";
export * from "./others/index.js";
