import { RootStore } from "../../store/stores.js";
import { __ } from "../../utils/i18n.js";

class FirstTimePointer {
    public readonly $tr: JQuery<HTMLElement>;

    /* v8 ignore next 4 */
    public constructor($tr: FirstTimePointer["$tr"]) {
        this.$tr = $tr;
        this.init();
    }

    public async close() {
        this.$tr.removeClass("rcpo-force-handler").addClass("updating-sequence rcpo-force-handler");

        try {
            await RootStore.get.postsStore.dismissFirstTimePointer();
        } finally {
            this.$tr.removeClass("updating-sequence rcpo-force-handler");
        }
    }

    private init() {
        this.$tr.addClass("rcpo-force-handler");
        const $pointer = this.$tr.find(".rcpo-handler") as any;
        const headline = __("Did you know that?");
        const desc = __(
            'You are now able to sort your post entries with drag & drop. Just drag this bar and you are ready to sort! Tip: You can enable/disable sortable functionality in "Screen settings".',
        );

        $pointer
            .pointer({
                pointerClass: "wp-pointer rcpo-handler-pointer",
                content: `<h3>${headline}</h3><p>${desc}</p>`,
                close: this.close.bind(this),
            })
            .pointer("open");
    }
}

export { FirstTimePointer };
