import $ from "jquery";

import { createHandlers } from "./createHandlers.js";
import { MakeSortable } from "./makeSortable.js";

const TABLE_BODY_SELECTOR = "#wpbody-content tbody#the-list";

/**
 * Apply a sortable handler to the available posts list via jQuery UI.
 */
function applyPostsTableSortable() {
    const $tbody = $(TABLE_BODY_SELECTOR);

    $tbody.parents("table").addClass("rcpo-sortable");

    // Make pseudo elements for handler
    createHandlers($tbody);

    // Make it sortable
    new MakeSortable($tbody);
}

export { TABLE_BODY_SELECTOR, applyPostsTableSortable };
