import { observable, runInAction } from "mobx";

import { isRatable } from "@devowl-wp/real-utils";
import { BaseOptions } from "@devowl-wp/utils";

import type { RootStore } from "./stores.js";

class OptionStore extends BaseOptions {
    // Implement "others" property in your Assets.php;
    @observable
    public others: {
        sortables: {
            [key: string]: boolean;
        };
        types: {
            post: {
                taxonomies: {
                    [key: string]: string;
                };
                showPostFirstTimePointer: boolean;
            };
        };
    };

    public readonly pureSlug: ReturnType<typeof BaseOptions.getPureSlug>;

    public readonly pureSlugCamelCased: ReturnType<typeof BaseOptions.getPureSlug>;

    public readonly rootStore: RootStore;

    public get isRatable() {
        return isRatable(this.slug);
    }

    public constructor(rootStore: RootStore) {
        super();
        this.rootStore = rootStore;
        this.pureSlug = BaseOptions.getPureSlug(process.env.slug);
        this.pureSlugCamelCased = BaseOptions.getPureSlug(process.env.slug, true);

        // Use the localized WP object to fill this object values.
        runInAction(() => Object.assign(this, (window as any)[this.pureSlugCamelCased]));
    }
}

export { OptionStore };
