import { flow } from "mobx";

import { request } from "../utils/request.js";
import { locationRestMovePost } from "../wp-api/move.post.js";
import { locationRestPostFirstTimePointerDelete } from "../wp-api/post-first-time-pointer.delete.js";

import type { RootStore } from "./stores.js";
import type { ParamsRouteMovePost, RequestRouteMovePost, ResponseRouteMovePost } from "../wp-api/move.post.js";
import type {
    ParamsRoutePostFirstTimePointerDelete,
    RequestRoutePostFirstTimePointerDelete,
    ResponseRoutePostFirstTimePointerDelete,
} from "../wp-api/post-first-time-pointer.delete.js";
import type { CancellablePromise } from "mobx/lib/api/flow";

class PostsStore {
    public readonly rootStore: RootStore;

    /* v8 ignore next 3 */
    public constructor(rootStore: RootStore) {
        this.rootStore = rootStore;
    }

    public updateBySequence: (sequence: number[]) => CancellablePromise<void> = flow(function* (
        this: PostsStore,
        sequence,
    ) {
        yield request<RequestRouteMovePost, ParamsRouteMovePost, ResponseRouteMovePost>({
            location: locationRestMovePost,
            request: {
                type: "post",
                sequence,
            },
        });
    });

    public dismissFirstTimePointer: () => CancellablePromise<void> = flow(function* (this: PostsStore) {
        yield request<
            RequestRoutePostFirstTimePointerDelete,
            ParamsRoutePostFirstTimePointerDelete,
            ResponseRoutePostFirstTimePointerDelete
        >({
            location: locationRestPostFirstTimePointerDelete,
        });
        this.rootStore.optionStore.others.types.post.showPostFirstTimePointer = false;
    });
}

export { PostsStore };
