/** @module components/Breadcrumb */

import React from "react";

import { Icon } from "@devowl-wp/react-folder-tree";

const ICON_OBJ_SEP = <Icon type="right" />;

/**
 * Simple breadcrumbs with arrows and a home icon.
 *
 * @property {string[]} path The pathes
 * @type React.Element
 */
export default ({ path, closeable = false, onClose }) => {
    let i = 0; // Use counter as key
    return (
        <div>
            <Icon type="folder" />
            &nbsp;&nbsp;
            {path.map((item) => {
                return (
                    <span key={i++}>
                        {item}&nbsp;{i < path.length && ICON_OBJ_SEP}&nbsp;
                    </span>
                );
            })}
            {!!closeable && <Icon type="close" onClick={onClose} />}
        </div>
    );
};
