/** @module components/FolderBox */

import React from "react";

import { Spin } from "@devowl-wp/react-folder-tree";

import { resolveIcon } from "../util/index.js";

export function FolderBoxHeader({ icon, folder }) {
    return (
        <span>
            {icon} {resolveIcon(folder.icon)} {folder.title}
        </span>
    );
}

/**
 * A component showing a container for a folder option. For example the metabox
 * or manual placement for nodes (rearrange).
 */
export default function ({ busy, icon, folder, errors = [], header = true, children }) {
    return (
        <Spin spinning={busy === undefined ? false : busy} size="small">
            <div className="rml-postbox">
                {header && (
                    <h2>
                        <FolderBoxHeader icon={icon} folder={folder} />
                    </h2>
                )}
                {errors.length > 0 && (
                    <ul style={{ marginTop: 0 }}>
                        {errors.map((e, i) => (
                            <li key={i}>{e}</li>
                        ))}
                    </ul>
                )}
                {children && <div className="inside">{children}</div>}
                {folder.id > 0 && (
                    <span style={{ float: "right", paddingBottom: "5px", fontSize: "10px", opacity: 0.5 }}>
                        ID #{folder.id}
                    </span>
                )}
            </div>
        </Spin>
    );
}
