/** @module components/ProFooter */
import T from "i18n-react";
import React from "react";

import { Alert, Icon } from "@devowl-wp/react-folder-tree";

import { Modal } from "./index.js";
import { getMediaDialogNextZIndex, i18n, request, rmlOpts } from "../util/index.js";

/**
 * Show a dialog box with a pro feature.
 *
 * @param [props.feature=undefined] {string} The feature to show
 * @extends React.Component
 */
class ProBox extends React.Component {
    constructor(props) {
        super(props);
    }

    redirect = () => {
        window.open(`${rmlOpts.others.proUrl}&feature=${this.props.feature}`, "_blank").focus();
        this.props.onClose();
    };

    render() {
        let title;
        let modalContent;
        const { feature } = this.props;
        if (feature) {
            const set = rmlOpts.others.lang.proFeatures[feature];
            title = (
                <span>
                    <Icon type="lock" /> {set.title} {rmlOpts.others.lang.proBoxTitle}
                </span>
            );
            modalContent = (
                <div>
                    {!!set.image && <img src={`https://assets.devowl.io/in-app/wp-real-media-library/${set.image}`} />}
                    <T.p text={set.description} />
                </div>
            );
        }

        return (
            <Modal
                visible={!!modalContent}
                title={title}
                onOk={this.redirect}
                onCancel={this.props.onClose}
                cancelText={i18n("proBoxCancel")}
                okText={i18n("proBoxOk")}
                zIndex={getMediaDialogNextZIndex()}
                className="rml-probox"
            >
                {modalContent}
            </Modal>
        );
    }
}

async function dismiss() {
    await request({
        location: {
            path: "/notice/lite",
            method: "DELETE",
        },
    });
    window.location.reload();
}

const ProFooter = ({ dismissible = false, feature }) => (
    <Alert
        message={
            <span>
                {rmlOpts.others.lang.proFooterText} &middot;{" "}
                <a href={`${rmlOpts.others.proUrl}&feature=${feature}`} target="_blank" rel="noreferrer">
                    {rmlOpts.others.lang.proLearnMore}
                </a>
                {dismissible && (
                    <>
                        {" "}
                        &middot;{" "}
                        <a onClick={dismiss} href="#">
                            {rmlOpts.others.lang.proDismiss}
                        </a>
                    </>
                )}
            </span>
        }
        type="info"
        style={{ marginBottom: "10px" }}
    />
);

export { ProFooter, ProBox };
