/** @module components */

import Modal from "antd/lib/modal";
import Progress from "antd/lib/progress";
import Spin from "antd/lib/spin";
import React from "react";
import "antd/lib/progress/style/index.css";
import "antd/lib/modal/style/index.css";
import "antd/lib/spin/style/index.css";

export {
    /**
     * @see https://ant.design/components/progress/
     * @returns React.Element
     * @function Progress
     */
    Progress,
    /**
     * @see https://ant.design/components/modal/
     * @returns React.Element
     * @function Modal
     */
    Modal,
    Spin,
};

/**
 * Create a WordPress dash icon.
 *
 * @property {string} name The icon
 * @see https://developer.wordpress.org/resource/dashicons/
 * @returns React.Element
 * @function
 */
export const DashIcon = ({ name }) => <span className={`dashicons dashicons-${name}`} />;
