// @see inc/comp/ExportMediaLibrary.class.php

import React from "react";
import rmlOpts from "rmlopts";

import { Menu } from "@devowl-wp/react-folder-tree";

import { DashIcon } from "../components/index.js";
import { IS_DARKMODE, addUrlParam, hooks, urlBuilder } from "../util/index.js";

if (+rmlOpts.others.massedge_wp_export) {
    const { Item } = Menu;
    const { ItemGroup } = Menu;
    const SUPPORTS_SUBFOLDERS = +rmlOpts.others.childrenSql > 1;

    /**
     * Handle click on a menu item so the correct admin page can be called.
     */
    const handleClick = function (e) {
        const baseUrl = urlBuilder({
            location: {
                path: "/massedge/export",
            },
        });
        const urlObj = new URL(baseUrl, window.location.href);
        urlObj.search = new URLSearchParams({
            type: e.key,
            folder: this.props.store.selectedId,
            _wpnonce: rmlOpts.restNonce,
        }).toString();
        window.location.href = urlObj.toString();
    };

    /**
     * A function which is called to render the dropdown menu.
     */
    const renderMenu = function () {
        const { store } = this.props;
        const { selected } = store;
        const isFolder = selected && (selected.id > 0 || selected.id === -1);

        if (!isFolder) {
            return <Menu style={{ visibility: "hidden" }} />;
        }

        return (
            <Menu onClick={handleClick.bind(this)} theme={IS_DARKMODE ? "dark" : "light"}>
                <ItemGroup key="wos" title="Without RML subfolders">
                    <Item key="wosFlat">As flat .zip file</Item>
                    <Item key="wosHierarchical">As hierarchical .zip file (physical structure)</Item>
                </ItemGroup>
                {selected.id !== -1 && (
                    <ItemGroup
                        key="ws"
                        title={`Include RML subfolders${SUPPORTS_SUBFOLDERS ? "" : " (not supported by your system)"}`}
                    >
                        <Item key="wsFlat" disabled={!SUPPORTS_SUBFOLDERS}>
                            As flat .zip file
                        </Item>
                        <Item key="wsHierarchicalRML" disabled={!SUPPORTS_SUBFOLDERS}>
                            As hierarchical .zip file (RML structure)
                        </Item>
                        <Item key="wsHierarchical" disabled={!SUPPORTS_SUBFOLDERS}>
                            As hierarchical .zip file (physical structure)
                        </Item>
                    </ItemGroup>
                )}
            </Menu>
        );
    };

    // Create download icon and register it to the toolbar
    hooks.register("tree/init", function () {
        this.stateRefs.ICON_DOWNLOAD_ZIP = <DashIcon name="download" />;
        this.stateRefs.renderDownloadZipMenu = renderMenu.bind(this);

        // When clicking on the download icon in "All" or "Unorganized" redirect to usual export page
        this.stateRefs.handleDownloadZipClick = function () {
            const { selectedId } = this.props.store;
            if (selectedId === "all" || this.props.store.selectedId === -1) {
                window.location.href = addUrlParam(window.location.href, "page", "mass-edge-export-media-library");
            }
        }.bind(this);

        this.state.toolbar_download_zip = {
            content: "ICON_DOWNLOAD_ZIP",
            toolTipTitle: "Download folder as zip",
            toolTipText: "A folder can be downloaded as flat or hierarchical zip.",
            menu: "resolve.renderDownloadZipMenu",
            toolTipPlacement: "topLeft",
            dropdownPlacement: "bottomLeft",
            onClick: "handleDownloadZipClick",
        };

        this.state.availableToolbarButtons.unshift("download_zip");
    });
}
