import { applyAntdDefinePlugin, createDefaultSettings } from "@devowl-wp/webpack-config";

const ANTD_PREFIX = "rpm-antd";

export default createDefaultSettings(import.meta.filename, "plugin", {
    override: ([config]) => {
        Object.assign(config.externals, {
            rml: "rml",
        });
    },
    definePlugin: (processEnv) => {
        applyAntdDefinePlugin(ANTD_PREFIX, processEnv);
        return processEnv;
    },
});
